/*
 * @version: 
 * @Descripttion: 
 * @Author: 王政
 * @Date: 2021-04-27 10:33:37
 * @LastEditTime: 2021-04-27 19:56:00
 * @LastModifyUser: 
 * @Remark: 
 */
!function () {
    var $ = layui.jquery, table = layui.table, laypage = layui.laypage;
    var bmSubscriptionController = new BmSubscriptionController();
    var layerIndex = null, formSubmit = null, mTableBodyData = [], mSortBodyData = [], currentTableBodyData = [];
    var subScriptionBMs = new BusinessModels();
    var subscriptionableBMs = new BusinessModels();
    var mLimit = 20;
    var mCurrentPage = 1;

    window.initSubscriptionForm = function(businessModelType, index, addSubscription){
        layerIndex = index;
        formSubmit = addSubscription;

        initSubscriptionHead();
        getSubscribedBMAndSubscriptionableBM(businessModelType);
        bindEvent();
    };

    function initSubscriptionHead(){
        var tableHead = [
            [
                { type: "checkbox" },
                { field: "businessModelName", title: "名称", sort: true },
                { field: "sourceOrganizationName", title: "所属组织", sort: true },
                { field: "description", title: "描述", sort: true }
            ]
        ];
        
        table.render({
            elem: '#subscriptionList',
            height: 410,
            cellMinWidth: 80, //全局定义常规单元格的最小宽度，layui 2.2.1 新增
            data: [],
            cols: tableHead,
            toolbar: false,
            autoSort: false,
            limit: 10
        });
    }

    function getSubscribedBMAndSubscriptionableBM(businessModelType){
        var succ = function (data) {
            subScriptionBMs.setBusinessModels(data);
            getSubscriptionableBM(businessModelType);
        };
        var fail = function (errorStatus, msg) {
            $Utils.loading.close();
            $Utils.openWindow.failWindow("获取可订阅模型列表", errorStatus, msg);
        };
        bmSubscriptionController.getSubscribedBM(businessModelType, true, succ, fail);
    }

    function getSubscriptionableBM(businessModelType){
        var succ = function (data) {
            subscriptionableBMs.setBusinessModels(data);
            loadModelList();
        };
        var fail = function (errorStatus, msg) {
            $Utils.loading.close();
            $Utils.openWindow.failWindow("获取已订阅模型列表", errorStatus, msg);
        };
        bmSubscriptionController.getSubscriptionableBM(businessModelType, true, succ, fail);
    }

    function loadModelList(){
        mTableBodyData = setTableBody();
        mSortBodyData = mTableBodyData;
        setTablePage(mTableBodyData);
        $Utils.loading.close();
    }

    function setTableBody(){
        var tableBodyData = [];
        var includeModels = [];
        for (var i = 0; i < subScriptionBMs.count; i++) {
            includeModels.push(subScriptionBMs.item(i).businessModelID);
        }
        for (var i = 0; i < subscriptionableBMs.count; i++) {
            var tempObj = {};
            for (var key in subscriptionableBMs.item(i)) {
                if (typeof subscriptionableBMs.item(i)[key] === "function") { continue; }
                tempObj[key] = subscriptionableBMs.item(i)[key];
            }
            if (includeModels.indexOf(subscriptionableBMs.item(i)) != -1){
                tempObj.LAY_CHECKED = true;
            }
            tableBodyData.push(tempObj);
        }
        return tableBodyData;
    }

    function setTablePage(data) {
        laypage.render({
            elem: "subscriptionPageBox",
            count: data.length,
            limit: mLimit,
            limits: [10, 20, 30, 40, 50],
            curr: mCurrentPage,
            layout: ["prev", "page", "next", "limit"],
            jump: function (obj, first) {
                $(".subscription-page-box .count-page").html("显示 " + (obj.curr * obj.limit - obj.limit + 1) + " 到 " + ((obj.curr * obj.limit) > data.length ? data.length : (obj.curr * obj.limit)) + " ，共 " + data.length + " 条记录");
                mLimit = obj.limit;
                loadTableBody(data, obj);
            }
        });
    }
    
    function loadTableBody(tableBodyData, obj) {
        currentTableBodyData = tableBodyData.concat().splice(obj.curr * obj.limit - obj.limit, obj.limit);
        table.reload("subscriptionList", { data: currentTableBodyData, limit: currentTableBodyData.length });
    }

    function bindEvent(){
        table.on('sort(subscriptionList)', function (obj) {
            var type = obj.type,
                field = obj.field,
                data = mSortBodyData,//表格的配置Data
                thisData = [];
            if (type === 'asc') { //升序
                thisData = $Utils.sorter(data, field);
            } else if (type === 'desc') { //降序
                thisData = $Utils.sorter(data, field, true);
            } else { //清除排序
                thisData = data;
            }
            setTablePage(thisData);
        });

        $(".search-button").click(function () {
            var searchValue = $(".search input[name=searchContent]").val();
            var searchData = [];
            if (searchValue == "") {
                searchData = mTableBodyData;
            } else {
                searchData = setSearchData(searchValue);
            }
            mSortBodyData = searchData;
            setTablePage(searchData);
        });

        $(".search input[name=searchContent]").keypress(function (e) {
            if (e.which == 13) {
                $(".search-button").click();
            }
        });

        table.on("tool(subscriptionList)", function (obj) {
            if (obj.event == "subscribe") {
                subscribeModel(obj);
            }
        });
    }

    function setSearchData(searchValue) {
        var tempArr = [];
        for (var i = 0; i < mTableBodyData.length; i++) {
            if (mTableBodyData[i].businessModelName.toLowerCase().indexOf(searchValue.toLowerCase()) != -1 || 
                (mTableBodyData[i].description && (mTableBodyData[i].description.toLowerCase().indexOf(searchValue.toLowerCase()) != -1))) {
                tempArr.push(mTableBodyData[i]);
            }
        }
        return tempArr;
    }

    function subscribeModel(obj) {
        $Utils.loading.open();
        var succ = function () {
            formSubmit();
            obj.update({
                subscriptionType: 1
            });
            $Utils.loading.close();
            layer.msg("订阅成功。", { icon: 1 });
        };
        var fail = function (errorStatus, msg) {
            $Utils.loading.close();
            $Utils.openWindow.failWindow("订阅模型", errorStatus, msg);
        };
        bmSubscriptionController.subscribeBusinessModel(obj.data.businessModelID, true, succ, fail);
    }
    
}();